# 🎰 Casino Affiliate Reporting Dashboard

A blazing-fast PHP dashboard for casino affiliate reporting with a beautiful dark theme inspired by acebet.com.

## Features

- 📊 **Real-time Dashboard** - KPI cards, profit trends, casino performance table
- 🔐 **Secure Authentication** - Session-based login with bcrypt password hashing
- ⚙️ **Settings Page** - Manage casino APIs, Pushover notifications, change password
- 📈 **Historical Data** - MySQL storage for trend analysis and charts
- 🔔 **Pushover Notifications** - Get alerts when profit changes by ±$100
- 🎨 **Dark Theme** - Beautiful acebet.com inspired design

## Supported Casino APIs

- **Affilka** (JSON) - BC Game, Thrill, PlayBet, etc.
- **Cellxpert** (XML) - JackBit, CryptoLeo, Casinok, 2up
- **Afflines** - Niyvi and other Afflines network casinos

## Requirements

- PHP 7.4+ with extensions: cURL, JSON, XML, PDO
- MySQL 5.7+
- Apache with mod_rewrite (optional)

## Installation

### 1. Upload Files
Upload the entire `php-dashboard` folder to your cPanel public_html directory.

### 2. Create MySQL Database
In cPanel:
1. Go to **MySQL Databases**
2. Create a new database (e.g., `casino_dashboard`)
3. Create a new user with a strong password
4. Add user to database with **All Privileges**

### 3. Configure Database Connection
Edit `config/database.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'your_database_name');
define('DB_USER', 'your_database_user');
define('DB_PASS', 'your_database_password');
```

### 4. Run Installation Script
Visit `https://yourdomain.com/install.php` in your browser.
This will create all necessary tables and the default admin user.

### 5. Login
- **Username:** `admin`
- **Password:** `#Youtube1234`

⚠️ **Change your password immediately after first login!**

### 6. Delete install.php
For security, delete `install.php` from your server after installation.

### 7. Set Up Cron Job (Optional)
For automatic daily profit snapshots and notifications:

In cPanel → Cron Jobs, add:
```
0 */4 * * * /usr/bin/php /home/username/public_html/casino-dashboard/cron.php >> /home/username/logs/cron.log 2>&1
```

Or for web-based cron, edit `cron.php` and change `YOUR_SECRET_CRON_KEY` to a random string, then set up a cron to visit:
```
https://yourdomain.com/cron.php?key=YOUR_SECRET_CRON_KEY
```

## Configuration

### Adding Casino APIs

1. Login and go to **Settings**
2. Click **Add Casino**
3. Fill in:
   - **Casino Name** - Display name
   - **API Type** - Affilka, Cellxpert, or Afflines
   - **API URL** - Your affiliate API endpoint
   - **API Key** - Your API authentication key
   - **Affiliate ID** - Required for Cellxpert
   - **Revenue Share %** - Your NGR percentage (default 100%)
   - **BL Threshold** - Minimum FTD deposit for CPA (USD)
   - **CPA Amount** - CPA bonus per qualifying FTD (USD)

### Pushover Notifications

1. Create a Pushover account at [pushover.net](https://pushover.net)
2. Create an Application/API Token
3. Get your User Key
4. In Settings → Pushover Notifications:
   - Enter your API Token and User Key
   - Set the notification threshold (default $100)
   - Enable notifications
   - Click "Test Notification" to verify

### Notification Logic

The dashboard tracks the last saved overall profit value. When you:
- View the dashboard and click "Check Notifications"
- Run the cron job

It compares the current total profit with the last saved value. If the difference is ≥ $100 (or your threshold), a Pushover notification is sent.

## File Structure

```
php-dashboard/
├── index.php              # Login page
├── dashboard.php          # Main dashboard
├── settings.php           # Settings page
├── logout.php             # Logout handler
├── install.php            # First-time setup
├── cron.php               # Cron job script
├── .htaccess              # Apache security config
├── config/
│   ├── database.php       # Database connection
│   └── config.php         # App configuration
├── includes/
│   ├── auth.php           # Authentication functions
│   ├── functions.php      # Helper functions
│   ├── casinos.php        # Casino data aggregator
│   └── pushover.php       # Pushover notifications
├── api/
│   ├── affilka.php        # Affilka JSON handler
│   ├── cellxpert.php      # Cellxpert XML handler
│   └── afflines.php       # Afflines handler
└── assets/
    ├── css/style.css      # Dark theme styles
    └── js/charts.js       # Chart.js config
```

## Security Features

- CSRF token protection on all forms
- Password hashing with bcrypt
- Session-based authentication with timeout
- Input sanitization and output escaping
- Prepared statements for all database queries
- .htaccess protection for sensitive files

## Troubleshooting

### "Database connection failed"
- Verify database credentials in `config/database.php`
- Ensure MySQL user has proper privileges

### API data not loading
- Enable debug mode (checkbox in date filters)
- Check the raw API response in the debug output
- Verify API URL and credentials are correct

### Pushover not working
- Click "Test Notification" in Settings
- Verify your API token and user key
- Check that notifications are enabled

## Support

This dashboard is provided as-is. For modifications or issues, you may need to adapt the API handlers (`api/*.php`) to match your specific casino affiliate API response formats.

## License

For personal use only. Not for redistribution.
