<?php
/**
 * Application Configuration
 */

// Session configuration
define('SESSION_LIFETIME', 7200); // 2 hours
define('SESSION_NAME', 'casino_dashboard');

// Default admin credentials (change password after first login!)
define('DEFAULT_USERNAME', 'admin');
define('DEFAULT_PASSWORD', '#Youtube1234');

// Cron: secret key for web-based cron runs (cron.php?key=...)
// IMPORTANT: Change this to a long random string.
define('CRON_WEB_KEY', '00cddc2b205efa90f725a504b052e81a');

// Pushover notification threshold (in USD)
define('PUSHOVER_THRESHOLD', 100);

// Timezone
date_default_timezone_set('UTC');

// Error reporting (set to 0 in production)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Start session with secure settings
function initSession(): void {
    if (session_status() === PHP_SESSION_NONE) {
        ini_set('session.cookie_httponly', 1);
        ini_set('session.cookie_secure', isset($_SERVER['HTTPS']));
        ini_set('session.use_strict_mode', 1);
        ini_set('session.gc_maxlifetime', SESSION_LIFETIME);
        session_name(SESSION_NAME);
        session_start();
    }
}

// CSRF Token generation
function generateCSRFToken(): string {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

// CSRF Token validation
function validateCSRFToken(string $token): bool {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// Sanitize output
function h(string $str): string {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

// Format currency
function formatMoney(float $amount): string {
    $prefix = $amount < 0 ? '-$' : '$';
    return $prefix . number_format(abs($amount), 2);
}

// Format currency with color class
function formatMoneyWithClass(float $amount): string {
    $class = $amount >= 0 ? 'text-profit' : 'text-loss';
    return '<span class="' . $class . '">' . formatMoney($amount) . '</span>';
}
